--[[---------------------------------------------------------------------------
	Chocolatier Two Port View
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local portNameFont = { standardFontName, kSixteen, DefaultColor }

local port = gSim.port

-------------------------------------------------------------------------------
-- Prepare the port layout

portLayout = {}
local labels = {}

local buttonX = 5
local buttonY = 20

for _,item in ipairs(port.layout) do
	local b = nil
	if type(item) == "function" then
		b = item()
	elseif ((not item.startweek) or (item.startweek <= gSim.weeks)) and
			((not item.endweek) or (item.endweek >= gSim.weeks))
	then
		if item.PrepareForLayout then
			local y = item.labely or item.y
			local x = item.labelx
			if not x then
				x = item.x
				if x and x > (ui.screenWidth - 125) then x = (ui.screenWidth - 125) end
			end
			
			if x and y then
				b = item:PrepareForLayout(x-50,y-bsgFontHeight(popupFont)/2)
			else
				b = item:PrepareForLayout()
			end			
			
			if item.x and item.y and item.name then
				local iClosure = item
				table.insert(labels,
					Frame
					{
						x=x-50,y=y-bsgFontHeight(popupFont)/2, h=bsgFontHeight(popupFont),
						fit=true,empty=true,
						corner="control/rollover_corner",
						left="control/rollover_left",
						top="control/rollover_top",
						ornament="",
						Rectangle
						{
							x=0,y=0,h=kMax, color=PopupColor, inset=2, alpha=.8,
							AppendStyle { font = popupFont, flags=kHAlignLeft+kVAlignTop },
							TightText { x=0,y=0, label=item.name },
						}
					})
			end
		end
		
		if (not b) and item.OnActivate then
			local i = item	-- for closure
			b = TextButton { x=buttonX, y=buttonY, label=item.name or tostring(item),
					command = function() i:OnActivate() end }
			buttonY = buttonY + 45
		end
	end
	
	if b then table.insert(portLayout, b) end
end


-------------------------------------------------------------------------------

local darksky = {}
-- HACK: Fireworks in San Francisco... prepare dark sky background
if port.name == "sanfrancisco" then
	local n = LQuest:Variable("bcsign")
	if n > 5 then
		darksky = { Bitmap { image="ports/sf_darksky" } }
	end
end

-------------------------------------------------------------------------------

MakeDialog
{
	bsgScreen
	{
		Bitmap
		{
			name="port",
			x=kCenter,y=kCenter,
			image = "ports/"..port.name,
			
			Group(darksky),
		},
		
		Port
		{
			x=kCenter,y=kCenter,w=kMax,h=kMax,
			xOffset=ui.xOffset, yOffset=ui.yOffset,
			Group(portLayout),
			
			Window { x=kCenter,y=kCenter,w=kMax,h=kMax, name="buildinglabels", Group(labels), },
		},
		
		Bitmap { image = "ports/banner",x=297+ui.xOffset,y=ui.yOffset,
			Text { x=19,y=14,w=169,h=20, flags=kVAlignTop+kHAlignCenter, label=LabelString(port.name), font=portNameFont },
		},
		
		NormalLedger(),
	}
}

gViewMode = "port"
SetLedgerMode("port")
SetMusicState("normal")
port:SetAmbient()
bsgTriggerAd()			-- TOGETHER
StopProductionAnim()	-- Just in case